unit Algorithms;

interface

uses Windows, math, Common,
     strUtils, //fr PosEx;
     dialogs, sysutils, graphics, GraphUtils;

type

  SearchAlgorithms = (

      // Prfix-Suche:
      ppp, naiv, kmp, kmp_ur,

      // Suffix-Suche
      bm, bm_ur, sun, bmh,

      // Faktor-Suche
      bdmoo, bdmrec, bom,

      // Parallel
      so1, sa,  bndm );


const AlgorithmNames  : Array[Searchalgorithms] of AnsiString
      = (
          // Prfix-Suche
           'Pos', 'Naiver Algorithmus', 'Knuth-Morris-Pratt', 'KMP (unrolled)',

          // Suffix-Suche
           'Boyer-Moore', 'Boyer-Moore (unrolled)', 'QuickSearch (Sunday)', 'Horspool (unrolled)',

          // Faktor-Suche
           'Backward Dawg Matching (OOP)', 'Backward Dawg Matching',
                    'Backward Oracle Matching (BOM)' ,

          // Parallel
           'Shift-Or', 'Shift-And', 'BNDM'
         );

      Colors: Array[SearchAlgorithms] of TColor
       = (
          // Prfix-Suche (3)
          clyellow, clWhite, clSilver, clGray,

          // Suffix-Suche (4)
          clLime, clgreen, clblue, clSkyBlue,

          // Faktor-Suche (3)
          clMaroon, clred, $000080FF {Orange},

          // Parallel (3)
          clPurple, $00BE00C4,clFuchsia
       );



type

  TAlgTimeArray = Array[SearchAlgorithms] of Int64;
  TSimpleTrefferArray = Array[SearchAlgorithms] of TSimpleTrefferList;
  TTimesArray = Array of TAlgTimeArray;

  TStatistics = Array of Array of TAlgTimeArray;


// Berechnet das Next-Array fr KMP
function Preprocess_KMP(p: AnsiString): TIntArray;
// Fhrt eine Suche mit dem Algorithmus von KMP durch und liefert den ersten Treffer zurck
// (und dann Abbruch)
function Search_KMP(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
// Ein Versuch, KMP zu beschleunigen
function Search_KMP_Unrolled(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// Boyer-Moore-Preprocessing: Bad-Character-Regel
function PreProcess_BM_BC(p: AnsiString): TBC_IntArray;
// Boyer-Moore-Preprocessing: Good-Suffix-Regel
function PreProcess_BM_GS(p: AnsiString): TIntArray;
// Suche mit BM
function Search_BM(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
function Search_BM_Unrolled(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// PreProcessing fr Horspool (leicht anders als BC_BM)
function PreProcess_BMH_BC(p: AnsiString): TBC_IntArray;
// Suche mit Horspool
function Search_BMH_Unrolled(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// Variante von Sunday
function PreProcess_Sunday(p: AnsiString): TBC_IntArray;
function Search_Sunday(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// Preprocessing fr Shift-OR
function PreProcess_SO(p: AnsiString; Out lim: Cardinal): TBC_CardinalArray;
// Suche mit Shift-OR, Variante1
function Search_SO1(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// Preprocessing fr Shift-AND
function PreProcess_SA(p: AnsiString): TBC_CardinalArray;

// Suche mit Shift-AND
function Search_SA(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// BNDM-Algorithmus
function PreProcess_BNDM(p: AnsiString): TBC_CardinalArray;
function PreProcess_BNDM64(p: AnsiString): TBC_Int64Array;
function Search_BNDM(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// BOM
function PreProcess_BOM(p: AnsiString): TBOM_Oracle;
function Search_BOM(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// BDM
function Search_BDMOO(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
function Search_BDMRec(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;

// Fhrt einen Algorithmus aus
function SimpleSearch(t, p: AnsiString; alg: SearchAlgorithms; Trefferlist: TSimpleTrefferList): Boolean;


implementation

function Search_Naiv(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var k, j, m, n: Integer;
begin
  result := 0;
  m := Length(p);
  n := Length(t);

  k := 1;
  // for it := 1 to n - m + 1 do
  while (k <= n - m + 1) do
  begin
    j := 1;
    while (j <= m) and (t[k + j - 1] = p[j]) do
      inc(j);
    if j = m+1 then
    begin
      if assigned(Trefferlist) then
                        Trefferlist.Add(Pointer(k));
      k := k + 1;
      if result = 0 then
        result := k;
      //k := k + m;
    end else
      inc(k);
  end;
end;



function Preprocess_KMP(p: AnsiString): TIntArray;
var j, t, m: Integer;
begin
  m := Length(p);
  SetLength(result, m+1);
  j := 1;
  t := 0;
  result[1] := 0;
  while j < m do
  begin
    while (t > 0) AND (p[j] <> p[t]) do t := result[t];
    t := t+1;
    j := j+1;
    if p[j] = p[t] then
      result[j] := result[t]
    else
      result[j] := t;
  end;
end;

function Search_KMP(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var j, k, m, n: Integer;
    Next: TIntArray;
begin
  k := 1;
  m := Length(p);
  n := Length(t);
  result := 0;
  Next := Preprocess_KMP(p);
  repeat
      j := 1;
      while (j <= m) AND (k <= n) do
      begin
        while (j > 0) AND (t[k] <> p[j]) do
          j := Next[j];
        inc(k);
        inc(j);
      end;
      if j = m+1 then
      begin
        if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-m));
        if result = 0 then
          result := k-m;
        //k := k;  // hier einfach weitermachen...
        k := k-m + 1;
      end;
  until (k > n);
end;

function Search_KMP_Unrolled(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var j, k, m, n: Integer;
    a: Char;
    Next: TIntArray;
label
    GetStarted, CharMatched, Loop;
begin
  // Verbesserungen wie bei kmp77 vorgeschlagen
  m := Length(p);
  n := Length(t);
  a := p[1];

  p := p + chr(0);
  t := t + chr(1) + a;
  Next := Preprocess_KMP(p);
  next[m+1] := -1;
  result := 0;

  k := 1;
 
  repeat
    j := 1;
    GetStarted:  // j=1
      While t[k]<>a do inc(k);
      if k>n then break;    // Text abgearbeitet
    CharMatched:
      inc(j);
      inc(k);
    Loop: // j>0
      if t[k] = p[j] then goto CharMatched;
      j := next[j];
      if j=1 then goto GetStarted;
      if j=0 then
      begin
        j := 1;
        inc(k);
        goto GetStarted;
      end;
      if j>0 then goto Loop;
      if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-m));
      if result = 0 then
        result := k-m;
      k := k-m + 1;
  until (k>n);
end;

// Boyer-Moore-Preprocessing: Bad-Character-Regel
function PreProcess_BM_BC(p: AnsiString): TBC_IntArray;
var  m,i: Integer;
     c: Char;
begin
  m := Length(p);
  for c := low(char) to High(Char) do
    result[c] := m;
  for i := 1 to m do
    result[p[i]] := m-i;
end;

// Boyer-Moore-Preprocessing: Good-Suffix-Regel
function PreProcess_BM_GS(p: AnsiString): TIntArray;
var back: TIntArray;
    j,t,m,i, l, r: Integer;
begin
  m := length(p);
  setlength(result, m+1);
  setlength(back, m+1);

  // Initialisierung
  for j := 0 to m do
    result[j] := m;

  // Phase 1
  back[m] := m+1;
  j := m;
  t := m+1;
  while j > 0 do
  begin
     // So macht es Aho
     back[j] := t;
     while (t <= m) and (p[j] <> p[t]) do
     begin
       result[t] := min(result[t], t-j);
       t := back[t];
     end;
     dec(j);
     dec(t);
  end;

  // Phase 2
  r := t ;
  l := 1;
  while r < m do
  begin
      for i := l to r do
          result[i] := min(result[i], r);
      l := r+1;
      r := back[r];
  end;
end;

// Suche mit BM
function Search_BM(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var m, n, k, j: Integer;
    GS: TIntArray;
    BC: TBC_IntArray;
begin
  m := Length(p);
  n := Length(t);

  GS := PreProcess_BM_GS(p);
  BC := PreProcess_BM_BC(p);

  // k: Position des Musters im Text (aber vom Endes des Musters!)
  k := m;
  result := 0;

  while k <= n do
  begin
    j := 0;

    while (j < m) and (p[m-j] = t[k-j]) do
      inc(j);

    if (j = m) then
    begin
      if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-j+1));
      if result = 0 then
        result := k-j+1;
      k := k + 1;
      //k := k + m; //break;
    end else
    begin
      k := k + max(
        GS[m-j],
        max(1, BC[t[k-j]] - j)
      );
    end;
  end;
end;

function Search_BM_Unrolled(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var m, n, k, j: Integer;
    GS: TIntArray;
    BC: TBC_IntArray;
    BC_last: Integer;
    Large: Integer;
begin
  // ACHTUNG: DEN HIER NOCHMAL TESTEN; OB DER BERHAUPT FUNKTIONIERT ;-)
  m := Length(p);
  n := Length(t);
  Large := m + n + 1;

  GS := PreProcess_BM_GS(p);
  BC := PreProcess_BM_BC(p);

  // "echten" BC-Shift merken
  BC_last := BC[p[m]];
  // BC(lastCh) mit "Large" berschreiben
  BC[p[m]] := Large;

  k := m;
  result := 0;

  while k <= n do
  begin

      //fast loop
      repeat
        k := k + BC[t[k]];
      until k > n;

      //undo
      if k <= Large then
        //Muster nicht gefunden
        break
      else
        k := k - Large;

      j := 1;
      // slow loop
      while (j < m) and (p[m-j] = t[k-j]) do
        inc(j);

      if j=m then
      begin
        // Muster gefunden
        //result := k - j + 1;
        //k := k + m;//break;
        if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-j+1));
        if result = 0 then
        result := k-j+1;
        k := k + 1;
      end else
      begin

          // Muster verschieben
          if t[k-j] = p[m] then
            k := k + max(
                      GS[m-j], max(1, BC_last - j)
                    )
          else
            k := k + max(
                      GS[m-j], max(1, BC[t[k-j]] - j)
                    );
      end;

  end;
end;



// PreProcessing fr Horspool (leicht anders als BC_BM)
// Wie BM_BC, nur letztes Zeichen auslassen
function PreProcess_BMH_BC(p: AnsiString): TBC_IntArray;
var i, m: Integer;
    c: Char;
begin
  m := Length(p);
  for c := low(Char) to High(Char) do
    result[c] := m;
  for i := 1 to m-1 do     // !! m-1 !!
    result[p[i]] := m-i;
end;

// Suche mit Horspool, direkt die unrolled-Variante. Sehr hnlich zu BM_Unrolled
function Search_BMH_Unrolled(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var m, n, k, j: Integer;
    BC: TBC_IntArray;
    BC_last: Integer;
    Large: Integer;
begin
  // ACHTUNG: DEN HIER NOCHMAL TESTEN; OB DER BERHAUPT FUNKTIONIERT ;-)
  m := Length(p);
  n := Length(t);
  Large := m + n + 1;

  BC := PreProcess_BMH_BC(p);

  // "echten" BC-Shift merken
  BC_last := BC[p[m]];
  // BC(lastCh) mit "Large" berschreiben
  BC[p[m]] := Large;

  k := m;
  result := 0;

  while k <= n do
  begin
      //fast loop
      repeat
        k := k + BC[t[k]];
      until k > n;

      //undo
      if k <= Large then
        //Muster nicht gefunden
        break
      else
        k := k - Large;

      j := 1;
      // slow loop
      while (j < m) and (p[m-j] = t[k-j]) do
        inc(j);

      if j=m then
      begin
        // Muster gefunden
        //result := k - j + 1;
        //k := k + m; //oder: break;
        if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-j+1));
        if result = 0 then
          result := k-j+1;
        k := k + 1;
      end else
      begin
          // Muster verschieben
          if t[k] = p[m] then
            k := k + BC_last
          else
            k := k + BC[t[k]];
      end;
  end;
end;

// Variante von Sunday
function PreProcess_Sunday(p: AnsiString): TBC_IntArray;
var i, m: Integer;
    c: Char;
begin
  m := Length(p);
  for c := Low(Char) to High(Char) do
    result[c] := m + 1; // !! Ja, m+1
  for i := 1 to m do
    result[p[i]] := m-i + 1;  // auch hier +1 !!
end;
function Search_Sunday(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var m, n, k, j: Integer;
    BC: TBC_IntArray;
begin
  m := Length(p);
  n := Length(t);
  BC := PreProcess_Sunday(p);

  // k: Position des Musters im Text (aber vom Endes des Musters!)
  k := m;
  result := 0;

  while k <= n-1 do
  begin
    j := 0;

    while (j < m) and (p[m-j] = t[k-j]) do
      inc(j);

    if (j = m) then
    begin
      //result := k-j + 1;
      //k := k + m; //break;
      if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-j+1));
      if result = 0 then
        result := k-j+1;
      k := k + 1;
    end else
    begin
      k := k + BC[t[k+1]]
    end;
  end;
  // Spezialfall result = n-m+1 abfangen
  // Wir knnen die Hauptschleife nur bis n-1 laufen lassen (wegen Zugriffs auf t[k+1])
  // Problem: Wenn da Muster am Ende vorkommt, muss noch ein Durchlauf OHNE Verschiebung gestartet werden
  if (k=n) then
  begin
    j := 0;
    while (j < m) and (p[m-j] = t[k-j]) do
      inc(j);
    if (j = m) then
    begin
      //result := k-m + 1;
      if result = 0 then
        result := k-m+1;
      if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k-m+1));
    end;

  end;
end;


// Preprocessing fr Shift-OR
function PreProcess_SO(p: AnsiString; Out lim: Cardinal): TBC_CardinalArray;
var i,m: Integer;
  j: cardinal;
  c: Char;
begin
  //Fillchar(result[0], length(result)*SizeOf(Cardinal), $FF) ;
  // Da tut sich so gut wie nichts.
  for c := Low(Char) to High(Char) do
    result[c] := NOT Cardinal(0);

  m := Length(p);
  j := 1;
  lim := 0;
  for i := 1 to m do
  begin

    result[p[i]] := result[p[i]] AND (NOT j);
    lim := lim OR j;
    j := j shl 1;
  end;


  lim := NOT (lim shr 1);
end;

// Suche mit Shift-OR, Variante1
function Search_SO1(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var n,m, i: Integer;
  B: TBC_CardinalArray;
  lim, state: Cardinal;
begin
  m := length(p);
  // Nur Muster mit Lnge <= 32 suchen
  if m > 32 then
    result := -1 //Search_BM(t,p)
  else
  begin
      B := PreProcess_SO(p, lim);
      result := 0;
      n := length(t);

      state := NOT Cardinal(0);
      for i := 1 to n do
      begin
        state := (state shl Cardinal(1)) OR B[t[i]];
        
        if state < lim then
        begin
          //result := i-m+1;
          //state := Not Cardinal(0);
          if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(i-m+1));
          if result = 0 then
            result := i-m+1;
        end;
      end;
  end;
end;


// Preprocessing fr Shift-AND
function PreProcess_SA(p: AnsiString): TBC_CardinalArray;
var i,m: Integer;
  j: cardinal;
begin
  //for i := 0 to 255 do
  //  result[i] := 0;
  ZeroMemory(@result[Chr(0)],length(result)*SizeOf(Cardinal));
  m := Length(p);
  j := 1;
  for i := 1 to m do
  begin
    result[p[i]] := result[p[i]] or j;
    j := j shl 1;
  end;
end;
// Suche mit Shift-AND
function Search_SA(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var B: TBC_CardinalArray;
    m,n,i: Integer;
    state,mask: Cardinal;
begin
  m := length(p);
  // Nur Muster mit Lnge <= 32 suchen
  if m > 32 then
    result := -1 //Search_BM(t,p)
  else
  begin
      B := PreProcess_SA(p);
      state := 0;
      result := 0;
      n := length(t);
      mask := 1 shl (m-1);
      for i := 1 to n do
      begin
        state := ((state shl 1) OR 1) AND B[t[i]];
        if (state AND mask) <> 0 then
        begin
          //result := i-m+1;
          //state := 0;
          if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(i-m+1));
          if result = 0 then
            result := i-m+1;
        end;
      end;
  end;
end;

// BNDM-Algorithmus
function PreProcess_BNDM(p: AnsiString): TBC_CardinalArray;
var i,m: Integer;
  j: cardinal;
begin
  ZeroMemory(@result[Chr(0)],length(result)*SizeOf(Cardinal));
  m := Length(p);
  j := 1;
  for i := m downto 1 do       // Andersrum als bei Shift-AND !
  begin
    result[p[i]] := result[p[i]] or j;
    j := j shl 1;
  end;
end;
// Dasselbe wie oben, nur mit Int64
function PreProcess_BNDM64(p: AnsiString): TBC_Int64Array;
var i,m: Integer;
  j: int64;
begin
  ZeroMemory(@result[Chr(0)],length(result)*SizeOf(Int64));
  m := Length(p);
  j := int64(1);
  for i := m downto 1 do       // Andersrum als bei Shift-AND !
  begin
    result[p[i]] := result[p[i]] or j;
    j := j shl int64(1);
  end;
end;

function Search_BNDM(t, p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var k, m, n, last, j: Integer;
    B: TBC_CardinalArray;
    state, mask: Cardinal;
    B64: TBC_Int64Array;
    state64, mask64: Int64;
begin
  result := 0;
  m := length(p);
  // Nur Muster mit Lnge <= 32 suchen
  if m > 62 then
    result := -1 // Search_BM(t,p)
  else
      if m > 32 then
      begin
          // Suche mit der Int64-Variante
          B64 := PreProcess_BNDM64(p);
          k := 0;
          n := length(t);
          mask64 := Int64(1) shl int64(m-1);
          while k <= n-m do
          begin
            j := m;
            last := m;
            //state := (1 shl m) - 1;  // 1^m
            state64 := (High(Int64) shr (63-m));
            while state64 <> 0 do
            begin
              state64 := state64 AND B64[t[k+j]];
              dec(j);
              if (state64 AND mask64) <> 0 then
              begin
                if j>0 then
                  last := j
                else
                begin
                    // Muster gefunden
                    //result := k+1;
                    if assigned(Trefferlist) then
                      Trefferlist.Add(Pointer(k+1));
                    if result = 0 then
                        result := k+1;
                    last := 1;  //m
                    //state64 := 0;
                end;
              end;
              state64 := state64 shl Int64(1);
            end;
            k := k + last;
          end;
      end else
            begin
              B := PreProcess_BNDM(p);
              k := 0;
              n := length(t);
              mask := (1 shl (m-1));
              while k <= n-m do
              begin
                j := m;
                last := m;
                //state := (1 shl m) - 1;  // 1^m
                state := (High(Cardinal) shr (32-m));
                while state <> 0 do
                begin
                  state := state AND B[t[k+j]];
                  dec(j);
                  if (state AND mask) <> 0 then
                  begin
                    if j>0 then
                      last := j
                    else
                    begin
                        // Muster gefunden
                        //result := k+1;
                        if assigned(Trefferlist) then
                          Trefferlist.Add(Pointer(k+1));
                        if result = 0 then
                            result := k+1;
                        // last := 1; // m
                        //state := 0;
                    end;
                  end;
                  state := state shl 1;
                end;
                k := k + last;
              end;
            end;
end;

// Aufbau des Faktor-Orakles fr BOM
function PreProcess_BOM(p: AnsiString): TBOM_Oracle;
var
    // "Supply Function" 
    S: TIntArray;
    m, i: Integer;
    ic: Char;

      // len: Lnge des bereits abgearbeiten Musters (also m im Buch)
      procedure Add_Letter(len: Integer; c: Char; delta: TBOM_Oracle);
      var k: Integer;
      begin
          delta[len,c] := len + 1; // Der "Standard-bergang"
          k := S[len];
          while (k > -1) AND (delta[k,c] = -1) do
          begin
              delta[k,c] := len + 1;
              k := S[k];
          end;
          if k=-1 then
            S[len+1] := 0
          else
            S[len+1] := delta[k,c];
      end;

begin
    // Result initialisieren mit -1
    m := length(p);
    Setlength(Result, m+1);
    for i := 0 to m do
      for ic := Low(Char) to High(Char) do
        Result[i,ic] := -1;
    // S initialisieren
    Setlength(S, m+1);
    S[0] := -1;

    for i := m downto 1 do
    begin
      Add_letter(m-i, p[i], result);
    end;
end;

function Search_BOM(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var delta: TBOM_Oracle;
    k, j, m, n, state: Integer;
begin
  delta := PreProcess_BOM(p);
  m := length(p);
  n := length(t);
  k := 0;
  result := 0;
  while k <= n-m do
  begin
      state := 0;
      j := m;
      while (j > 0) AND (state <> -1) do
      begin
          state := delta[state, t[k+j]];
          dec(j);
      end;
      if state <> -1 then
      begin
          // Muster gefunden
          //result := k + 1;
          //k := k + m;
          if assigned(Trefferlist) then
            Trefferlist.Add(Pointer(k+1));
          if result = 0 then
            result := k+1;
          k := k + 1;
      end else
      begin
          k := k + j + 1;
      end;
  end;
end;

function Search_BDMOO(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var D: TDawg;
    pr: AnsiString;
    k,n,m,j,shift: Integer;
    u: TNode;
begin
  D := TDawg.Create;

  pr := ReverseString(p);

  D.Build(pr);

  n := length(t);
  m := length(p);
  k := 0;
  result := 0;

  while k <= n-m do
  begin

      j := m;
      shift := m;
      u := D.Init;
      while (u <> NIl) and (u.GetTarget(t[k+j]) <> NIL) do
      begin
          u := u.GetTarget(t[k+j]);
          dec(j);
          if (u.Terminal) then
          begin
              if j > 0 then
                  shift := j
              else
              begin
                  // Muster gefunden
                  //result := k + 1;
                  //shift := m;
                  if assigned(Trefferlist) then
                      Trefferlist.Add(Pointer(k + 1));
                  if result = 0 then
                    result := k+1;
                  shift := 1;
              end;
          end; // u.terminal
      end; // while u
      k := k + shift;
  end; //while k

  D.Free;
end;


function Search_BDMrec(t,p: AnsiString; Trefferlist: TSimpleTrefferList): Integer;
var D: TDawgRecord;
    pr: AnsiString;
    k,n,m,j,shift: Integer;
    u: Integer;
begin

  pr := ReverseString(p);

  D := BuildDawg(pr);

  n := length(t);
  m := length(p);
  k := 0;
  result := 0;

  while k <= n-m do
  begin

      j := m;
      shift := m;
      u := 0;
      while (u >= 0) and (D.Target[u,t[k+j]] >= 0) do
      begin
          u := D.Target[u,t[k+j]];
          dec(j);
          if (D.Terminal[u]) then
          begin
              if j > 0 then
                  shift := j
              else
              begin
                  // Muster gefunden
                  //result := k + 1;
                  //shift := m;
                  if assigned(Trefferlist) then
                    Trefferlist.Add(Pointer(k+1));
                  if result = 0 then
                    result := k+1;
                  shift := 1;
              end;
          end; // u.terminal

      end; // while u
      k := k + shift;
  end; //while k
end;


function SimpleSearch(t, p: AnsiString; alg: SearchAlgorithms; Trefferlist: TSimpleTrefferList): Boolean;
var idx, moreidx: Integer;
begin
    case alg of
      ppp  : begin
                  idx := pos(p,t);
                  if assigned(Trefferlist) and (idx > 0) then
                      Trefferlist.Add(Pointer(idx));
                  moreidx := idx;
                  while (moreidx > 0) and (moreidx < length(t)) do
                  begin
                    //idx := newidx;
                    moreidx := posEx(p,t,moreidx+1);
                    if assigned(Trefferlist) and (moreidx > 0) then
                      Trefferlist.Add(Pointer(moreidx));
                  end;
             end;
      naiv   : idx := Search_Naiv(t, p, Trefferlist);
      kmp    : idx := Search_KMP(t, p, Trefferlist);
      kmp_ur : idx := Search_KMP_Unrolled(t, p, Trefferlist);
      bm     : idx := Search_BM(t, p, Trefferlist);
      bm_ur  : idx := Search_BM_Unrolled(t, p, Trefferlist);
      bmh    : idx := Search_BMH_Unrolled(t, p, Trefferlist);
      sun    : idx := Search_Sunday(t,p, Trefferlist);
      so1    : idx := Search_SO1(t, p, Trefferlist);
      sa     : idx := Search_SA(t,p, Trefferlist);
      bndm   : idx := Search_BNDM(t,p, Trefferlist);
      bom    : idx := Search_BOM(t,p, Trefferlist);
      bdmoo  : idx := Search_BDMoo(t,p, Trefferlist);
      bdmrec : idx := Search_BDMrec(t,p, Trefferlist);
      else idx := -1;
    end;
    result := idx > -1;
end;





end.
